/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.soap;

import filenet.pe.soap.IPESOAPCommand;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.soap.VWSOAPRouterURL;
import filenet.vw.soap.util.VWSOAPUtils;

public class SOAPCommand
implements IPESOAPCommand {
    private static final String m_className = "SOAPCommand";
    private String m_router = "vwrouter";
    private String m_serverURL = null;
    private String m_token = null;
    private String m_sessionId = null;
    private static Logger logger = Logger.getLogger("filenet.pe.soap.rpc");

    public SOAPCommand(VWSOAPRouterURL soapRouterURL, String token) {
        this.m_router = soapRouterURL.getRouterName();
        this.m_serverURL = soapRouterURL.getServerURL();
        this.m_token = token;
        this.m_sessionId = soapRouterURL.getJSESSIONID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendCommand(String rpc, byte[] cmd) throws VWException {
        String m_method = rpc + ":" + this.m_router;
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        try {
            byte[] byArray = (byte[])VWSOAPUtils.invoke(this.m_serverURL, "sendCommand", new String[]{"routerName", "rpc", "cmd"}, new Object[]{this.m_router, rpc, cmd}, new Class[]{String.class, String.class, byte[].class}, this.m_token, this.m_sessionId);
            Object var6_5 = null;
            if (logger.isFinest()) {
                logger.exiting(m_className, m_method);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_6 = null;
                if (!logger.isFinest()) break block4;
                logger.exiting(m_className, m_method);
            }
            throw throwable;
        }
    }

    protected void cleanup() {
        try {
            VWSOAPUtils.invoke(this.m_serverURL, "cleanup", null, null, null, null, this.m_sessionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.cleanup();
    }
}

